#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
	int r, size, myrank, offset;
	char myrank_formatted;

	MPI_File fh;
	MPI_Status s;

	MPI_Init(&argc, &argv);

	MPI_Comm_size(MPI_COMM_WORLD, &size);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);

	r = MPI_File_open(MPI_COMM_WORLD, "my-rank.txt", MPI_MODE_CREATE|MPI_MODE_WRONLY, MPI_INFO_NULL, &fh);
	// printf("return: %d\n", r);

	for (int i=0; i<10; i++) {
		// Calculates the offset
		offset = (myrank + (i * size)) * sizeof(char);

		// Define the character rank
		myrank_formatted = '0' + myrank;

		// printf("rank: %c\ti: %d\toffset: %d\n", myrank_formatted, i, offset);

		MPI_File_write_at(fh, offset, &myrank_formatted, 1, MPI_CHAR, &s);
	}

	MPI_File_close(&fh);

	MPI_Finalize();

	return 0;
}
